var _functions = {};

jQuery(function($) {

	"use strict";

	/*###############*/
	/* FUNCTION ON DOCUMENT READY */ 
	/*###############*/

	if (navigator.userAgent.indexOf("Firefox") >= 0) {
		$('body').addClass('firefox');
	}
	if (navigator.userAgent.indexOf('Edge') >= 0) {
		$('body').addClass('edge');
	}
	if (navigator.userAgent.indexOf("Trident") >= 0) {
		$('body').addClass('ie');
	}
	if (navigator.userAgent.indexOf('Safari') >= 0 && navigator.userAgent.indexOf('Chrome') < 0) {
		$('body').addClass('safari');
	}
	if (navigator.userAgent.indexOf('Chrome') >= 0 && navigator.userAgent.indexOf('Edge') < 0) {
		$('body').addClass('chrome');
	}

	setTimeout( function(){
		$("#loader-wrapper").fadeOut(0);
	},100);

	$('[data-bg]').each(function(i, el){
		$(el).css({'background-image': 'url('+$(el).data('bg')+')'});
	});

	$('img[data-src]').each(function(i, el){
		$(el).attr({'src': $(el).data('src')});
	});

	/*###############*/
	/* ANIMATIONS */
	/*###############*/

	_functions.customAnimation = function() {
		if ($('.animation').length) {
			$('.animation').each(function() {
				if ($(this).offset().top < $(window).scrollTop() + $(window).height()) {
					$(this).addClass('animated');
				}
			});
		}
	}
	_functions.scrollHeadern = function() {
		var a = $(window).scrollTop();

        if(a > 20) {
			$('.header').addClass('scrolled');
        } else if(a < 20) {
			$('.header').removeClass('scrolled');
        }
	}

	/*###############*/
	/* SCROLL */
	/*###############*/

	$(window).on('scroll load', function(){
		_functions.customAnimation();
		_functions.scrollHeadern();
	});

	/*###############*/
	/* INPUT MATERIAL */
	/*###############*/

	$('.input-wrapper-material .input-material').on('focus', function(){
		$(this).parent().addClass('focus');
	});
	$('.input-wrapper-material .input-material').on('blur', function () {
		$(this).parent().removeClass('focus');
	});
	$('.input-wrapper-material .input-material').on('keyup', function () {
		if(!$(this).val()) $(this).parent().removeClass('typed');
		else $(this).parent().addClass('typed');
	});

	/*###############*/
	/* POPUP */
	/*###############*/

	function removeScroll() {
		$('html').css({
			"overflow": "hidden"
		});
	}
	function addScroll() {
		$('html').css({
			"overflow": "visible"
		});
	}
	_functions.openPopup = function(popup){
		$('.popup-content').removeClass('active');
		$(popup + ', .popup-wrapper').addClass('active');
		removeScroll();
	};

	_functions.closePopup = function () {
        $('.popup-wrapper, .popup-content').removeClass('active');

        $('#video-popup iframe').remove();

        addScroll();
    };

    _functions.videoPopup = function (src, videoType) {
        if (videoType === 'youtube') {
            $('#video-popup .embed-responsive').html('<iframe src="' + src + '"></iframe>');
        } else if (videoType === 'html') {
            $('#video-popup .embed-responsive').html('<video autoplay controls playsinline class="active"><source src="'+src+'" type="video/mp4"></video>');
        }
        _functions.openPopup('#video-popup');
    };

    $(document).on('click', '.video-popup', function (e) {
        e.preventDefault();
        var src, videoType;

        if ($(this).data('youtube-src')) {
            src = $(this).data('youtube-src');
            _functions.videoPopup(src, 'youtube');
        } else if ($(this).data('html-src')) {
            src = $(this).data('html-src');
            _functions.videoPopup(src, 'html');
        }
    });

	$(document).on('click', '.open-popup', function(e){
		e.preventDefault();
		_functions.openPopup('.popup-content[data-rel="' + $(this).data('rel') +'"]');
	});

	$(document).on('click', '.popup-wrapper .btn-close, .popup-wrapper .close-popup, .popup-wrapper .layer-close, .popup-wrapper .close-popup', function(e){
		e.preventDefault();
		_functions.closePopup();
	});

	// thanks popup

	_functions.thanksPopup = function(){
		event.preventDefault();
		_functions.openPopup('.popup-content[data-rel="thanks-popup"]');
		
		// setTimeout( function(){
		// 	_functions.closePopup();
		// },3000);
	};

		// swiper sliders 

		_functions.getSwOptions = function(swiper){
			var options = swiper.data('options'),
				slidesLength = swiper.find('.swiper-slide').length;


			options = (!options || typeof options !=='object') ? {} : options;
			var $p = swiper.closest('.swiper-entry');

			if(slidesLength === 1) $p.addClass('single-slide-swiper');

			if(!options.pagination) options.pagination = {
				el: $p.find('.swiper-pagination')[0],
				clickable: true
			};
			if(!options.navigation) options.navigation = {
				nextEl: $p.find('.swiper-button-next')[0],
				prevEl: $p.find('.swiper-button-prev')[0]
			};
			options.preloadImages = false;
			options.lazy = {loadPrevNext: true};
			options.observer = true;
			options.observeParents = true;
			options.watchOverflow = true;
			options.speed = 500;
			options.roundLengths = false;
			// if(isTouchScreen) options.direction = "horizontal";
			return options;
		};
		_functions.initSwiper = function(el){
			var swiper = new Swiper(el[0], _functions.getSwOptions(el));
		};
		
		$('.swiper-entry .swiper-container').each(function () {
			_functions.initSwiper($(this));
		});
		$('.swiper-thumbs').each(function () {
			var top = $(this).find('.swiper-container.swiper-thumbs-top')[0].swiper,
				bottom = $(this).find('.swiper-container.swiper-thumbs-bottom')[0].swiper;
			top.thumbs.swiper = bottom;
			top.thumbs.init();
			top.thumbs.update();
		});
		$('.swiper-control').each(function () {
			var top = $(this).find('.swiper-container')[0].swiper,
				bottom = $(this).find('.swiper-container')[1].swiper;
			top.controller.control = bottom;
			bottom.controller.control = top;
		});


	//burger btn-show

	$(document).on('click', '.btn-show', function(){

		let r = $(this).data('rel');

		if($('.' + r).hasClass('active')){
			$(this).removeClass('active');
			$('.' + r).removeClass('active');
			// $('html').removeClass('overflow-hidden');
		}else{
			$(this).addClass('active');
			$('.' + r).addClass('active');
			// $('html').addClass('overflow-hidden');
		}

	});

	$('a.onScroll').on('click', function(){

		event.preventDefault();
	
		var a = $(this).attr('href');
			
			if($(a).length){
				var t = $(a).offset().top - 20;

				$('body,html').animate({scrollTop: t}, 1000);

				if($('.header .navigation-mob').hasClass('active')){

					$('.header .navigation-mob').removeClass('active');
					$('.header .btn-menu').removeClass('active');
				}
			}
		
	});

	//paralax

	$(document).ready(function (){
		if($('.rellax').length && $(window).width() > 991){
			var rellax = new Rellax('.rellax', {
				center: true
			});
		}
	});

	//input mask

	$('[type = "tel"]').inputmask("+38(999)999-99-99");


	//tabs

	$('.tab-title').on('click', function() {
		$(this).parent().toggleClass('active');
	});
	$('.tab-toggle div').on('click', function() {
		var tab = $(this).closest('.tabs').find('.tab');
		var i = $(this).index();
		$(this).addClass('active').siblings().removeClass('active');
		tab.eq(i).siblings('.tab:visible').fadeOut(function() {
			tab.eq(i).fadeIn();
		});
		$(this).closest('.tab-nav').removeClass('active').find('.tab-title').text($(this).text());
	});

		/*###############*/
	/* lightbox */
	/*###############*/

	// $('.lightbox-wrapper .open-img').on('click', function(e){
	// 	if (screen.width < 998) {
	// 		e.preventDefault();
	// 		e.unbind('click');
	// 	}
	// });

	var lightBoxOptions = {
		animationSlide: false,
		loop: false,
		disableScroll: false,
		captionSelector: 'self',
		closeText: '<button class="lightbox-close"></button>',
		alertErrorMessage: 'Картинку не знайдено. Наступна картинка буде завантажена для перегляду.',
		history: false,
		widthRatio: 1,
		heightRatio: 1
	},
	lightboxSelector = $('.lightbox-wrapper'),
	lightboxLength = lightboxSelector.length,
	lightbox = [];
	for(var i = 0; i < lightboxLength; i++){
		lightbox[i] = $(lightboxSelector[i]).find('.open-img').simpleLightbox(lightBoxOptions);
	}


});
 