jQuery(function ($) {

    "use strict";

    var $rangers = $('.ranger');

    function clickOnPip(slider, $el) {
        slider.set(+$el.data('value'));
    }

    $rangers.each(function () {
        var $this = $(this),
            rangeJson = $this.data('range-json'),
            pipsValuesArr = [],
            $thisInputRel = $this.data('range-rel'),
            $thisInput = $('.ranger-input[data-range-rel="' + $thisInputRel + '"]'),
            startValue = +$this.data('start'),
            $noUiValue;

        for (var key in rangeJson) {
            pipsValuesArr.push(rangeJson[key][0])
        }

        noUiSlider.create($this[0], {
            start: [startValue],
            step: 1,
            connect: 'lower',
            range: rangeJson,
            pips: {mode: 'values', values: pipsValuesArr, density: 0}
        });

        $noUiValue = $this.find('.noUi-value');

        $noUiValue.on('click', function () {
            clickOnPip($this[0].noUiSlider, $(this));
        });

        $this[0].noUiSlider.on('update', function (values) {
            var v = +values[0];
            if ($thisInput.length) {
                $thisInput.val(v.toFixed(0));
                // $thisInput.trigger('change');
            }

            $noUiValue.each(function () {
                var $t = $(this),
                    $thisVal = +$t.data('value');

                ($thisVal <= v) ? $t.addClass('active') : $t.removeClass('active');
            })
        });

    });

    //if we have number like 5.00 - remove 00 from the end
    function roundIfNoFloat(num) {
        if (num % num.toFixed(0)) {
            return num;
        } else {
            return num.toFixed(0);
        }
    }

    //convert price from data attr and output it into html
    function convertPrice(priceNum, $elToOutput, multiplier) {
        var price = roundIfNoFloat( +(priceNum*multiplier).toFixed(2) );
        $elToOutput.text(price);
    }

    //find actual price in price array accordingky to ranger position
    function updatePriceOutput(rangeValue, dataArr, $wrapper, priceMultiplier) {

        for (var i = 0; i < dataArr.length; i++) {
            if (rangeValue >= dataArr[i].employees[0] && rangeValue <= dataArr[i].employees[1]) {
                //regular price
                convertPrice(+dataArr[i]['price-reg'], $wrapper.find('.js-reg-price'), priceMultiplier);

                //premium price
                convertPrice(+dataArr[i]['price-prem'], $wrapper.find('.js-premium-price'), priceMultiplier);

                if (dataArr[i]['price-enterprise']) {
                    //enterprise price
                    convertPrice(+dataArr[i]['price-enterprise'], $wrapper.find('.js-enterprise-price'), priceMultiplier);

                    $wrapper.find('.js-show-enterprise-price').show(0);
                    $wrapper.find('.js-hide-enterprise-price').hide(0);
                } else {
                    $wrapper.find('.js-show-enterprise-price:visible').hide(0);
                    $wrapper.find('.js-hide-enterprise-price:hidden').show(0);
                }

                break;
            }
        }
    }

    if ($('.calculate-price-ranger').length) {
        $('.calculate-price-ranger').each(function() {
            var $this = $(this),
                $wrap = $this.closest('.tab-entry');


            $this[0].noUiSlider.pricing = priceDataJson['pricing'+$this.data('range-rel')];

            $this[0].noUiSlider.on('update', function (values) {
                var v = +values[0];

                updatePriceOutput(v, this.pricing, $wrap, +$wrap.find('.price-multiplier:checked').val());
            });
        });

        if ($('.price-multiplier').length) {
            $('.price-multiplier').on('change', function() {
                var $this = $(this),
                    $wrap = $this.closest('.tab-entry'),
                    ranger = $wrap.find('.calculate-price-ranger')[0].noUiSlider;

                updatePriceOutput(ranger.get(), ranger.pricing, $wrap, +$this.val());
            });
        }
    }

    $('.number-input').on('change input', function (e) {
        e.target.value = e.target.value.replace(/\D/g, '');
    });

    $('.ranger-input').on('change input', function (e) {
        var $this = $(this),
            $thisRel = $this.data('range-rel'),
            $rangerEl = $('.ranger[data-range-rel="' + $thisRel + '"]');

        if ($rangerEl.length) {
            $rangerEl[0].noUiSlider.set(e.target.value);
        }
    });


});